---
name: managing-design-document
description: Manage design.md documents for Spec-Driven Development (SDD). Handles creating, updating, and reading design.md files while enforcing "how to build" constraints. Trigger when working with SDD design.md file.
allowed-tools: Read, Write, Edit, Glob, Grep, Bash, BashOutput
---

# managing design document
## Purpose
This Skill maintains `design.md` documents for Spec-Driven Development (SDD) based on `design_template.md` standards. It ensures consistent creation, updates, and retrieval of requirement-focused spec files while strictly separating "what to build" (Spec) from "how to build it" (Design).

## Prerequisites
Project directory structure of design.md :
```
.codeartsdoer/
└── specs/
    └──{{feature-name}}/
        └── design.md
```

## Core Capabilities
### 1. Create Design Files
Must follow these rules  step-by-step to generate new `design.md` files:
- Check if the feature-specific directory (`.codeartsdoer/specs/{{feature-name}}/`) does **not** contain a `design.md`
- If missing: Combine the user's requirements with the structure/requirements from design_template.md to generate the `.codeartsdoer/specs/{{feature-name}}/design.md` file. Note: The `.codeartsdoer/specs/{{feature-name}}/design.md` format must be strictly followed `design_template.md`.
- Include mandatory sections from the template (e.g., Purpose, Requirements, Scenarios) and populate content aligned with user needs
- Do **not** overwrite existing feature-specific design.md files if it already exists

### 2. Update Design Files
Must follow these rules step-by-step to update `design.md` files:
- All requirement modifications (additions, edits, removals) are written **only** to `.codeartsdoer/specs/{{feature-name}}/design.md`
- Clear design.md file and write user-edited design file to that, When user update the design file.

### 3. Read & Search Design Files
- Support retrieval of content:
  - Feature-specific specs: `.codeartsdoer/specs/{{feature-name}}/design.md`
- Use `Grep` to search for specific requirements, scenarios, or keywords across spec files
- Use `Read` to load full spec content for review or modification
- Return search/reading results in a structured format (e.g., section headers + matching content snippets)

## Attention Content
Focus on architecture and approach, **not line-by-line code implementation**!

## Next Steps
- For advanced `design.md` template usage, see design_template.md.

## Reference
design_template.md is shown as follows:
```markdown
# **1. 实现模型**

## **1.1 上下文视图**

## **1.2 服务/组件总体架构**

## **1.3 实现设计文档**

# **2. 接口设计**

## **2.1 总体设计**

## **2.2 接口清单**

# **4. 数据模型**
## **4.1 设计目标**

## **4.2 模型实现**

```